#!/bin/bash
command -v psql >/dev/null 2>&1 || { echo >&2 "PostgreSQL client application are required, but not found. Install PostgreSQL client and try again."; exit 1; }

read -p "Enter database host [127.0.0.1]: " db_host
db_host=${db_host:-127.0.0.1}

read -p "Enter database port [5432]: " db_port
db_port=${db_port:-5432}

read -p "Enter postgres user name for PACS db scheme (existing user) [PACS_USER]: " pacs_user
pacs_user=${pacs_user:-PACS_USER}

read -sp "Enter password for user ${pacs_user}: " pacs_pass
echo -e "\n"

echo "Updating database schema..."
PGPASSWORD=${pacs_pass} psql -h ${db_host} -p ${db_port} -U ${pacs_user} -d pacs -f update_to_2.1.0.sql
if [ $? -ne 0 ]; then
  echo "Updating database schema failed."
  exit 1
fi

echo "Updating database schema completed."
