START TRANSACTION;

ALTER TABLE DICOM_OBJECTS ADD COLUMN IF NOT EXISTS UPLOAD_DATE timestamp NOT NULL DEFAULT NOW()::timestamp,
ADD COLUMN IF NOT EXISTS COMPRESSED SMALLINT NOT NULL DEFAULT 0,
ADD COLUMN IF NOT EXISTS UPLOADED_TO_REGIONAL SMALLINT NOT NULL DEFAULT 0;
COMMENT ON COLUMN DICOM_OBJECTS.UPLOAD_DATE IS 'Date and time of object uploading';
COMMENT ON COLUMN DICOM_OBJECTS.COMPRESSED IS 'Flag is object already compressed';
COMMENT ON COLUMN DICOM_OBJECTS.UPLOADED_TO_REGIONAL IS 'Flag is object uploaded to the Regional PACS';
CREATE INDEX IF NOT EXISTS OBJECTS_ARCHIVED ON DICOM_OBJECTS(ID, UPLOAD_DATE, COMPRESSED);

ALTER TABLE DICOM_AE_TITLES ALTER COLUMN IP TYPE varchar(120);

COMMIT;
