START TRANSACTION;

ALTER TABLE DICOM_OBJECTS ADD COLUMN UPLOAD_DATE timestamp NOT NULL DEFAULT NOW()::timestamp;
ALTER TABLE DICOM_OBJECTS ADD COLUMN COMPRESSED SMALLINT NOT NULL DEFAULT 0;
COMMENT ON COLUMN DICOM_OBJECTS.UPLOAD_DATE IS 'Date and time of object uploading';
COMMENT ON COLUMN DICOM_OBJECTS.COMPRESSED IS 'Flag is object already compressed';
CREATE INDEX OBJECTS_ARCHIVED ON DICOM_OBJECTS(ID, UPLOAD_DATE, COMPRESSED);
ALTER TABLE DICOM_OBJECTS ADD COLUMN UPLOADED_TO_REGIONAL SMALLINT NOT NULL DEFAULT 0;
COMMENT ON COLUMN DICOM_OBJECTS.UPLOADED_TO_REGIONAL IS 'Flag is object uploaded to the Regional PACS';

COMMIT;
