#!/bin/bash
command -v mysql >/dev/null 2>&1 || { echo >&2 "Mysql client application are required, but not found. Install mysql client and try again."; exit 1; }

read -p "Enter database host [127.0.0.1]: " db_host
db_host=${db_host:-127.0.0.1}

read -p "Enter database port [3306]: " db_port
db_port=${db_port:-3306}

read -p "Enter mysql user name for PACS db scheme (existing user) [PACS_USER]: " pacs_user
pacs_user=${pacs_user:-PACS_USER}

read -sp "Enter password for user ${pacs_user}: " pacs_pass
echo -e "\n"

echo "Updating database schema..."
mysql -h $db_host -P $db_port -u ${pacs_user} -p${pacs_pass} < update_to_1.4.2.sql
if [ $? -ne 0 ]; then
  echo "Updating database schema failed."
  exit 1
fi

echo "Updating database schema completed."
