@echo off
setlocal EnableDelayedExpansion
echo The Inobitec DICOM Server ^(PACS^) installation script

set DEST_DIR=
set /p DEST_DIR="Enter the path to the folder to install the Inobitec DICOM Server (PACS) [C:\PACSServer]: "
if "!DEST_DIR!"=="" set "DEST_DIR=C:\PACSServer"
if exist "!DEST_DIR!" (
  echo The directory !DEST_DIR! is already exists.
  echo Delete the folder or use update_pacs.bat script to upgrade
  echo an existing version of Inobitec DICOM Server ^(PACS^).
  goto failed
)

set DB_HOST=
set /p DB_HOST="Enter database host ip [127.0.0.1]: "
if "!DB_HOST!"=="" set "DB_HOST=127.0.0.1"

:enter_port
set DB_PORT=
set /p DB_PORT="Enter database port [3306]: "
if "!DB_PORT!"=="" set DB_PORT=3306

set DB_USER=
set /p DB_USER="Enter database username [PACS_USER]: "
if "!DB_USER!"=="" set "DB_USER=PACS_USER"

set DB_PASS=
set /p DB_PASS="Enter database user password: "

set DEPLOY_DATABASE_HERE=
choice /m "Deploy database on the !DB_HOST! machine?"
if "!ERRORLEVEL!"=="1" (
  set "DEPLOY_DATABASE_HERE=true"
  set /p DB_ADMIN_USER="Enter database admin username [root]: "
  if "!DB_ADMIN_USER!"=="" set "DB_ADMIN_USER=root"
  
:enter_db_admin_pass
  set DB_ADMIN_PASS=""
  set /p "DB_ADMIN_PASS=Enter database admin password: "
  if "!DB_ADMIN_PASS!"=="" (
    echo The password can not be empty
    goto enter_db_admin_pass
  )
) else (
  set "DEPLOY_DATABASE_HERE=false"
)

set PACS_AE_TITLE=
set /p PACS_AE_TITLE="Enter the Inobitec DICOM server AETitle [PACS_Inobitec]: "
if "!PACS_AE_TITLE!"=="" set "PACS_AE_TITLE=PACS_Inobitec"

choice /m "Accept associations from any AETitles?"
if "!ERRORLEVEL!"=="1" (set "ACCEPT_FROM_ANY=true") else (set "ACCEPT_FROM_ANY=false")

choice /m "Activate unsecured DICOM store service?"
set UNSECURED_STORE_SERVICE_PORT=
if "!ERRORLEVEL!"=="1" (
  set "ACTIVATE_UNSECURED_STORE_SERVICE=true"
  set /p UNSECURED_STORE_SERVICE_PORT="Enter the unsecured DICOM store service port [3000]: "
) else (set "ACTIVATE_UNSECURED_STORE_SERVICE=false")
if "!UNSECURED_STORE_SERVICE_PORT!"=="" set "UNSECURED_STORE_SERVICE_PORT=3000"

choice /m "Activate unsecured DICOM MWL service?"
set UNSECURED_MWL_SERVICE_PORT=
if "!ERRORLEVEL!"=="1" (
  set "ACTIVATE_UNSECURED_MWL_SERVICE=true"
  set /p UNSECURED_MWL_SERVICE_PORT="Enter the unsecured DICOM MWL service port [3001]: "
) else (set "ACTIVATE_UNSECURED_MWL_SERVICE=false")
if "!UNSECURED_MWL_SERVICE_PORT!"=="" set "UNSECURED_MWL_SERVICE_PORT=3001"

choice /m "Activate secured DICOM store service?"
set SECURED_STORE_SERVICE_PORT=
if "!ERRORLEVEL!"=="1" (
  set "ACTIVATE_SECURED_STORE_SERVICE=true"
  set /p SECURED_STORE_SERVICE_PORT="Enter the secured DICOM store service port [3100]: "
) else (set "ACTIVATE_SECURED_STORE_SERVICE=false")
if "!SECURED_STORE_SERVICE_PORT!"=="" set "SECURED_STORE_SERVICE_PORT=3100"

choice /m "Activate secured DICOM MWL service?"
set SECURED_MWL_SERVICE_PORT=
if "!ERRORLEVEL!"=="1" (
  set "ACTIVATE_SECURED_MWL_SERVICE=true"
  set /p SECURED_MWL_SERVICE_PORT="Enter the secured DICOM MWL service port [3101]: "
) else (set "ACTIVATE_SECURED_MWL_SERVICE=false")
if "!SECURED_MWL_SERVICE_PORT!"=="" set "SECURED_MWL_SERVICE_PORT=3101"

set FREE_DISK_SPACE_LIMIT=
set /p FREE_DISK_SPACE_LIMIT="Enter free space storage limit [2048]: "
if "!FREE_DISK_SPACE_LIMIT!"=="" set "FREE_DISK_SPACE_LIMIT=2048"

set UNSECURED_HTTP_SERVICE_PORT=
set /p UNSECURED_HTTP_SERVICE_PORT="Enter the HTTP service port [8000]: "
if "!UNSECURED_HTTP_SERVICE_PORT!"=="" set "UNSECURED_HTTP_SERVICE_PORT=8000"

set WEB_ADMIN_USER=
set /p WEB_ADMIN_USER="Enter the WebAdmin user name [Admin]: "
if "!WEB_ADMIN_USER!"=="" set "WEB_ADMIN_USER=Admin"

:enter_web_admin_password
set WEB_ADMIN_PASSWORD=
set /p WEB_ADMIN_PASSWORD="Enter the WebAdmin user password: "
if "!WEB_ADMIN_PASSWORD!"=="" (
  echo The password can not be empty
  goto enter_web_admin_password
)

set SERVICE_NAME=
set /p SERVICE_NAME="Enter the Inobitec DICOM Server (PACS) service name [PACSServer]: "
if "!SERVICE_NAME!"=="" set "SERVICE_NAME=PACSServer"

set FREE_DISK_SPACE_WARNING_NOTIFY_LIMIT=
set /p FREE_DISK_SPACE_WARNING_NOTIFY_LIMIT="Enter the amount of free storage space at which a notification will be sent [4096]: "
if "!FREE_DISK_SPACE_WARNING_NOTIFY_LIMIT!"=="" set "FREE_DISK_SPACE_WARNING_NOTIFY_LIMIT=4096"

echo Copying files...
if not exist "!DEST_DIR!" mkdir "!DEST_DIR!"
if ERRORLEVEL 1 goto copy_files_failed
if not exist "!DEST_DIR!\bin" mkdir "!DEST_DIR!\bin"
if ERRORLEVEL 1 goto copy_files_failed
if not exist "!DEST_DIR!\conf" mkdir "!DEST_DIR!\conf"
if ERRORLEVEL 1 goto copy_files_failed
if not exist "!DEST_DIR!\logs" mkdir "!DEST_DIR!\logs"
if ERRORLEVEL 1 goto copy_files_failed
xcopy /E /Y ..\bin "!DEST_DIR!\bin\"
if ERRORLEVEL 1 goto copy_files_failed
if not exist "!DEST_DIR!\fonts" mkdir "!DEST_DIR!\fonts"
if ERRORLEVEL 1 goto copy_files_failed
xcopy /E /Y ..\fonts "!DEST_DIR!\fonts\"
if ERRORLEVEL 1 goto copy_files_failed
if not exist "!DEST_DIR!\Certs" mkdir "!DEST_DIR!\Certs"
if ERRORLEVEL 1 goto copy_files_failed
xcopy /E /Y ..\Certs "!DEST_DIR!\Certs\"
if ERRORLEVEL 1 goto copy_files_failed

echo Creating configuration file...
set CONFIG_FILE="!DEST_DIR!\conf\srv_settings.ini"

(echo database/conn_string=Server="!DB_HOST!;"Port="!DB_PORT!;"Database="pacs;"unix_socket="NULL;"client_flag="0;") > "!CONFIG_FILE!"
(echo database/user=!DB_USER!) >> "!CONFIG_FILE!"
(echo database/pass=!DB_PASS!) >> "!CONFIG_FILE!"
(echo database/driver=QMYSQL) >> "!CONFIG_FILE!"
(echo database/max_connections_number=100) >> "!CONFIG_FILE!"

(echo http_server/port=!UNSECURED_HTTP_SERVICE_PORT!) >> "!CONFIG_FILE!"
(echo web_admin/font_path=%DEST_DIR:\=/%/fonts/font.ttf) >> "!CONFIG_FILE!"

(echo dicom/store_service/unsecure/enabled=!ACTIVATE_UNSECURED_STORE_SERVICE!) >> "!CONFIG_FILE!"
(echo dicom/store_service/unsecure/port=!UNSECURED_STORE_SERVICE_PORT!) >> "!CONFIG_FILE!"

(echo dicom/accept_unknown=!ACCEPT_FROM_ANY!) >> "!CONFIG_FILE!"
(echo dicom/ae_title=!PACS_AE_TITLE!) >> "!CONFIG_FILE!"
(echo storage/free_disk_space_limit=!FREE_DISK_SPACE_LIMIT!) >> "!CONFIG_FILE!"

(echo dicom/mwl_service/unsecure/enabled=!ACTIVATE_UNSECURED_MWL_SERVICE!) >> "!CONFIG_FILE!"
(echo dicom/mwl_service/unsecure/port=!UNSECURED_MWL_SERVICE_PORT!) >> "!CONFIG_FILE!"

(echo dicom/store_service/secure/enabled=!ACTIVATE_SECURED_STORE_SERVICE!) >> "!CONFIG_FILE!"
(echo dicom/store_service/secure/port=!SECURED_STORE_SERVICE_PORT!) >> "!CONFIG_FILE!"

(echo dicom/mwl_service/secure/enabled=!ACTIVATE_SECURED_MWL_SERVICE!) >> "!CONFIG_FILE!"
(echo dicom/mwl_service/secure/port=!SECURED_MWL_SERVICE_PORT!) >> "!CONFIG_FILE!"

(echo web_admin/login=!WEB_ADMIN_USER!) >> "!CONFIG_FILE!"
(echo web_admin/password=!WEB_ADMIN_PASSWORD!) >> "!CONFIG_FILE!"
(echo web_admin/session_timeout=1800) >> "!CONFIG_FILE!"

(echo license_key=) >> "!CONFIG_FILE!"

(echo compression/level=0) >> "!CONFIG_FILE!"
(echo compression/compress_after=365) >> "!CONFIG_FILE!"
(echo autoremove/store_days=0) >> "!CONFIG_FILE!"

(echo regional_pacs/enabled=false) >> "!CONFIG_FILE!"

(echo notifications/storage_free_space_limit=!FREE_DISK_SPACE_WARNING_NOTIFY_LIMIT!) >> "!CONFIG_FILE!"

(echo logger/files_path=%DEST_DIR:\=/%/logs) >> "!CONFIG_FILE!"

if "!DEPLOY_DATABASE_HERE!"=="true" (
  echo Deploying database...
  (echo '') | sql_manager deploy !DB_HOST! !DB_PORT! !DB_ADMIN_USER! !DB_ADMIN_PASS! !DB_USER! !DB_PASS!
)

echo Adding service...
sc create !SERVICE_NAME! binPath= "!DEST_DIR!\bin\pacs_server.exe -cfg !CONFIG_FILE!" start= auto DisplayName= "Inobitec DICOM Server (PACS)"
if ERRORLEVEL 1 goto add_service_failed
choice /m "Add dependency from DBMS service?"
if not "!ERRORLEVEL!"=="1" goto after_adding_dependency

:enter_dbms_service_name
set DBMS_SERVICE_NAME=
set /p DBMS_SERVICE_NAME="Enter DBMS service name: "
if "!DBMS_SERVICE_NAME!"=="" (
  echo Skip adding DBMS service dependency.
  goto after_adding_dependency
)

sc config !SERVICE_NAME! depend= !DBMS_SERVICE_NAME!
if ERRORLEVEL 1 (
  echo Addin dependency failed. Is service !DBMS_SERVICE_NAME! exists?
  goto enter_dbms_service_name
)

:after_adding_dependency

echo Installing Inobitec DICOM Server ^(PACS^) completed.
goto end

:copy_files_failed
echo Copy the files failed.
goto failed

:add_service_failed
echo Add service failed.
goto failed

:failed
echo Installing Inobitec DICOM Server ^(PACS^) failed.

:end
pause
