#!/bin/bash
if [ "$(id -u)" != "0" ]; then
  echo "This script must be run as root." 1>&2
  exit 1
fi

inst_dir=/srv/PACSServer
if [ ! -d "$inst_dir" ]; then
  echo "The directory ${inst_dir} is not exists."
  echo "You can install the Inobitec DICOM Server (PACS) with deploy_pacs.sh script."
  exit 1
fi

function rollback() {
  echo "Rollback changes..."
  rm -rf "${inst_dir:?}"/bin
  cp -R "${inst_dir}"/bin_bak_"${timestamp}" "${inst_dir}"/bin
  if [ ! -z "${1}" ] && [ -e $1 ]
  then
    rm /etc/pacs-srv/srv_settings.ini
    cp $1 /etc/pacs-srv/srv_settings.ini
  fi
}

timestamp="$(date +"%d.%m.%y_%H.%M.%S")"

echo "Creating backups..."
mv "${inst_dir}"/bin "${inst_dir}"/bin_bak_"${timestamp}"

echo "Copying files..."
if ! cp -R ../bin ${inst_dir}/bin; then
  echo "Updating Inobitec DICOM Server (PACS) failed."
  rollback
  exit 1
fi

function prev_version_is_old () {
    current_dir=$PWD
    cd $1
    ver=`echo $(./pacs_server -v) | grep -Po '\d+\.\d+\.\d+.\d+'`
    cd $current_dir
    [ `echo $ver | cut -d "." -f 1` -le 2 ] && [ `echo $ver | cut -d "." -f 2` -lt 9 ]
}

function update_ini () {
  ini_bak=$3
  cp $1 $ini_bak

  sed -i '/\[General\]/d' $1
  #DB connection
  sed -i 's/conn_string/database\/conn_string/' $1
  sed -i 's/db_address/database\/address/' $1
  sed -i 's/db_port/database\/port/' $1
  sed -i 's/db_name/database\/name/' $1
  sed -i 's/user/database\/user/' $1
  sed -i 's/pass/database\/pass/' $1
  sed -i 's/max_connections_number/database\/max_connections_number/' $1
  sed -i 's/driver_type/database\/driver/' $1
  #HTTP Server
  sed -i '/activate_unsecure_http_service/d' $1
  sed -i 's/unsecure_http_service_port/http_server\/port/' $1
  sed -i 's/master_cookie/http_server\/master_cookie/' $1
  sed -i 's/acceptable_address/http_server\/acceptable_address/' $1
  #Admin Web Console
  sed -i 's/web_admin_path/web_admin\/files_path/' $1
  sed -i 's/web_admin_login/web_admin\/login/' $1
  sed -i 's/web_admin_password/web_admin\/password/' $1
  sed -i 's/web_admin_database\/password/web_admin\/password/' $1
  sed -i 's/web_admin_session_life_time/web_admin\/session_timeout/' $1
  sed -i 's/font_path/web_admin\/font_path/' $1
  #WADO
  sed -i 's/enable_wado_study_web_service/wado\/study_web_service\/enabled/' $1
  sed -i 's/wado_study_service_port/wado\/study_web_service\/port/' $1
  #DICOM Services
  sed -i 's/activate_unsecure_dicom_store_service/dicom\/store_service\/unsecure\/enabled/' $1
  sed -i 's/unsecure_dicom_store_service_port/dicom\/store_service\/unsecure\/port/' $1
  sed -i 's/activate_unsecure_dicom_mwl_service/dicom\/mwl_service\/unsecure\/enabled/' $1
  sed -i 's/unsecure_dicom_mwl_service_port/dicom\/mwl_service\/unsecure\/port/' $1
  sed -i 's/activate_secure_dicom_store_service/dicom\/store_service\/secure\/enabled/' $1
  sed -i 's/secure_dicom_store_service_port/dicom\/store_service\/secure\/port/' $1
  sed -i 's/activate_secure_dicom_mwl_service/dicom\/mwl_service\/secure\/enabled/' $1
  sed -i 's/secure_dicom_mwl_service_port/dicom\/mwl_service\/secure\/port/' $1
  sed -i 's/pacs_server_ae_title/dicom\/ae_title/' $1
  sed -i 's/accept_association_from_any/dicom\/accept_unknown/' $1
  sed -i 's/strict_dicom_standard/dicom\/strict_standard/' $1
  #Certificates
  sed -i 's/certs_path/dicom\/tls\/certs_path/' $1
  sed -i 's/cert_trusted_dir_path/dicom\/tls\/trusted_certs_path/' $1
  sed -i 's/cert_client_private_path/dicom\/tls\/scu_private_key/' $1
  sed -i 's/cert_client_public_path/dicom\/tls\/scu_public_cert/' $1
  sed -i 's/cert_server_private_path/dicom\/tls\/scp_private_key/' $1
  sed -i 's/cert_server_public_path/dicom\/tls\/scp_public_cert/' $1
  #RIS
  sed -i 's/ris_notifying/ris\/notifications_enabled/' $1
  sed -i 's/ris_ip/ris\/address/' $1
  sed -i 's/ris_port/ris\/port/' $1
  #Archiving
  sed -i 's/compression_level/compression\/level/' $1
  sed -i 's/uncompressing_store_days/compression\/compress_after/' $1
  #Connecting to a regional DICOM server
  sed -i 's/regional_pacs_enabled/regional_pacs\/enabled/' $1
  sed -i 's/regional_pacs_ae_title/regional_pacs\/ae_title/' $1
  sed -i 's/regional_pacs_preferred_transfer_syntax/regional_pacs\/preferred_ts/' $1
  sed -i 's/regional_pacs_address/regional_pacs\/address/' $1
  sed -i 's/regional_pacs_port/regional_pacs\/port/' $1
  sed -i 's/regional_pacs_secured_connection/regional_pacs\/use_tls/' $1
  sed -i 's/regional_pacs_certificate_filename/regional_pacs\/cert_filename/' $1
  sed -i 's/regional_pacs_extended_search/regional_pacs\/extended_search_enabled/' $1
  sed -i 's/regional_pacs_storage_commitment_enabled/regional_pacs\/storage_commitment_enabled/' $1
  sed -i 's/storage_commitment_time_interval/regional_pacs\/storage_commitment_interval/' $1
  sed -i 's/regional_pacs_connection_timeout/regional_pacs\/connection_timeout/' $1
  sed -i 's/regional_pacs_upload_timeout/regional_pacs\/upload_timeout/' $1
  sed -i 's/regional_pacs_association_lifetime/regional_pacs\/association_timeout/' $1
  #Removing old studies
  sed -i 's/store_days/autoremove\/store_days/' $1
  sed -i 's/enable_remove_old_series_by_storage/autoremove\/by_storage_enabled/' $1
  sed -i 's/confirm_remove_old_series_by_storage/autoremove\/by_storage_confirmed/' $1
  sed -i 's/remove_old_series_by_storage_thresold/autoremove\/threshold/' $1
  sed -i 's/remove_by_storage_not_uploaded/autoremove\/remove_not_uploaded_enabled/' $1
  #Service Threads
  sed -i 's/storage_worker_threads_count/workers\/thread_count/' $1
  sed -i 's/storage_worker_tasks_delay/workers\/delay/' $1
  sed -i 's/storage_worker_collect_compression_task_count/workers\/compression_task_count/' $1
  sed -i 's/storage_worker_collect_remove_task_count/workers\/autoremove_task_count/' $1
  sed -i 's/storage_worker_collect_upload_task_count/workers\/regional_pacs_task_count/' $1
  sed -i 's/remove_old_series_by_storage_collect_task_count/workers\/autoremove_by_storage_task_count/' $1
  #Notifications
  sed -i '/email_command/d' $1
  sed -i '/enable_email_storage_devices_notifying/d' $1
  sed -i 's/free_disk_space_warning_notify_limit/notifications\/storage_free_space_limit/' $1
  sed -i '/enable_email_save_file_failure_notifying/d' $1
  #Series import
  sed -i 's/chunk_size/import\/chunk_size/' $1
  sed -i 's/import_session_timeout/import\/session_timeout/' $1
  #Storage of studies
  sed -i 's/free_disk_space_limit/storage\/free_disk_space_limit/' $1
  sed -i 's/disk_free_space_check_frequency/storage\/disk_free_space_check_frequency/' $1
  sed -i 's/dcm_temporary_folder/storage\/dcm_temporary_folder/' $1
  sed -i 's/crop_long_accession_number/storage\/crop_long_accession_number/' $1
  #Logging
  enable_trace_string=`echo $(grep enableTraceLoggerLevel $ini_bak) | tr '[:upper:]' '[:lower:]'`
  sed -i '/enableTraceLoggerLevel/d' $1
  if [ ! -z "${2}" ] && [ -e $2 ]
  then
      level=`echo $(grep log4cpp.rootCategory $2) | cut -f1 -d"," | cut -d "=" -f 2`
      case "$level" in *DEBUG*) case "$enable_trace_string" in *true*) level=TRACE;; esac;; esac
      echo -e "\nlogger/level=$level" >> $1
      echo "logger/files_path=`echo $(grep log4cpp.appender.A1.fileName $2) | cut -d "=" -f 2 | sed 's/\./_/'`" >> $1
      echo "logger/max_file_size=`echo $(grep log4cpp.appender.A1.maxFileSize $2) | cut -d "=" -f 2`" >> $1
      echo "logger/max_file_count=`echo $(grep log4cpp.appender.A1.maxBackupIndex $2) | cut -d "=" -f 2`" >> $1
  else
      case "$enable_trace_string" in *true*) echo -e "\nlogger/level=TRACE";; esac
  fi
}

if prev_version_is_old "${inst_dir}"/bin_bak_"${timestamp}"
then
  echo "Update config..."
  config_dir=/etc/pacs-srv
  config_file=/etc/pacs-srv/srv_settings.ini
  bak_ini="${config_file}"_bak_"${timestamp}"

  update_ini ${config_file} ${config_dir}/log4cpp.ini ${bak_ini}

  if ! grep -q "database/driver" ${config_file}
  then
    echo -e "\ndatabase/driver=QPSQL" >> ${config_file}
  fi

  echo "Update service..."

  read -rp "Enter the Inobitec DICOM Server (PACS) service name [pacsserver]: " service_name
  service_name=${service_name:-pacsserver}
  systemctl is-active --quiet "${service_name}" && systemctl stop "${service_name}"
  service_file=/etc/systemd/system/${service_name}.service
  exex_start_string="ExecStart=${inst_dir}/bin/pacs_server -cfg ${inst_dir}/conf/srv_settings.ini"
  sed -i "s|ExecStart=.*|$exex_start_string|" $service_file || { echo "Change service ${service_name} failed."; rollback ${bak_ini}; exit 1; }
  systemctl daemon-reload
fi

echo "Updating completed"
