#!/bin/bash
echo The Inobitec DICOM Server \(PACS\) uninstallation script

if [ "$(id -u)" != "0" ]; then
  echo "This script must be run as root" 1>&2
  exit 1
fi

# Confirm uninstall
while true; do
  read -rp "Do you really want to uninstall Inobitec DICOM Server (PACS)? This action can not be aborted. [y/n] " yn
  case $yn in
    [Yy]* ) break;;
    [Nn]* ) exit 0;;
    * ) echo "Please answer \"y\" or \"n\".";;
  esac
done

# Stop server
read -rp "Enter the Inobitec DICOM Server (PACS) service name [pacsserver]: " service_name
service_name=${service_name:-pacsserver}
systemctl is-active --quiet "${service_name}" && systemctl stop "${service_name}"

# Delete db schema
while true; do
  read -rp "Do you want to delete database schema? [y/n] " yn
  case $yn in
    [Yy]* ) drop_db=true; break;;
    [Nn]* ) drop_db=false; break;;
    * ) echo "Please answer \"y\" or \"n\".";;
  esac
done

if [ "$drop_db" == "true" ]; then
  command -v psql >/dev/null 2>&1 || { echo >&2 "PostgreSQL client application are required, but not found. Install PostgreSQL client and try again."; exit 1; }

  read -rp "Enter database host [127.0.0.1]: " db_host
  db_host=${db_host:-127.0.0.1}

  read -rp "Enter database port [5432]: " db_port
  db_port=${db_port:-5432}

  read -rp "Enter postgres administrator user name [postgres]: " db_user
  db_user=${db_user:-postgres}

  read -rsp "Enter postgres administrator user password: " db_pass
  echo -e "\n"

  drop_database_sql="DROP DATABASE pacs;";
  echo "Delete database schema..."
  if ! PGPASSWORD="${db_pass}" psql -h "${db_host}" -p "${db_port}" -U "${db_user}" -c "${drop_database_sql}"; then
    echo "Delete schema failed. You should to drop schema manually."
  fi

  while true; do
    read -rp "Do you want to delete database user? [y/n] " yn
    case $yn in
      [Yy]* ) drop_db_user=true; break;;
      [Nn]* ) drop_db_user=false; break;;
      * ) echo "Please answer \"y\" or \"n\".";;
    esac
  done

  if [ "$drop_db_user" == "true" ]; then
    read -rp "Enter postgres user name for PACS db scheme [PACS_USER]: " pacs_user
    pacs_user=${pacs_user:-PACS_USER}

    drop_database_user_sql="DROP USER \"${pacs_user}\";"
    echo "Delete database schema user..."
    if ! PGPASSWORD="${db_pass}" psql -h "${db_host}" -p "${db_port}" -U "${db_user}" -c "${drop_database_user_sql}"; then
      echo "Delete database user failed. You should to drop database user manually."
    fi
  fi
fi

# Delete all PACS files
while true; do
  read -rp "Do you want to delete Inobitec DICOM Server (PACS) files? [y/n] " yn
  case $yn in
    [Yy]* ) delete_files=true; break;;
    [Nn]* ) delete_files=false; break;;
    * ) echo "Please answer \"y\" or \"n\".";;
  esac
done

if [ "$delete_files" == "true" ]; then
  inst_dir=/srv/PACSServer
  if [ ! -d "$inst_dir" ]; then
    echo "The directory ${inst_dir} is not exists."
    echo "It is seems like Inobitec DICOM Server (PACS) does not installed."
    exit 1
  fi

  config_dir=/etc/pacs-srv
  log_dir=/var/log/pacs-srv
  echo "Delete Inobitec DICOM Server (PACS) files..."
  rm -rf "$inst_dir" "$config_dir" "$log_dir"
  echo "Delete service..."
  service_file=/etc/systemd/system/${service_name}.service
  systemctl disable "${service_name}"
  rm -rf "${service_file}"
  systemctl daemon-reload

  # Ask for user delete
  while true; do
    read -rp "Do you want to delete user who own Inobitec DICOM Server (PACS) service? [y/n] " yn
    case $yn in
      [Yy]* ) delete_user=true; break;;
      [Nn]* ) delete_user=false; break;;
      * ) echo "Please answer \"y\" or \"n\".";;
    esac
  done

  if [ "$delete_user" == "true" ]; then
    read -rp "Enter the user name [pacs]: " service_user_name
    service_user_name=${service_user_name:-pacs}

    echo "Delete service user..."
    if ! userdel -r "${service_user_name}"; then
      echo "Delete service user failed. You should to delete user manually."
    fi
  fi
fi

echo Uninstalling Inobitec DICOM Server \(PACS\) completed.
